using System;
using System.Collections;

namespace gov.va.med.vbecs.BOL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Luke Meyer</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>8/23/2002</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>Holds a collection of divisions objects.</summary>

	#endregion

	public class DivisionCollection : CollectionBase
	{
		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/19/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5001"> 
		///		<ExpectedInput>None.</ExpectedInput>
		///		<ExpectedOutput>Valid instance of the class with zero count.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5002"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Creates an empty instance of the class. 
		/// </summary>
		public DivisionCollection() : base() {}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6295"> 
		///		<ExpectedInput>Division object.</ExpectedInput>
		///		<ExpectedOutput>Reference to supplied division object.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6296"> 
		///		<ExpectedInput>Null instead of division to add. </ExpectedInput>
		///		<ExpectedOutput>ArgumentNullException.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		///		Adds a new division to the divsion collection object.
		/// </summary>
		/// <param name="divisionToAdd">Division object to add.</param>
		/// <returns>Reference to added division object.</returns>
		public Division Add( Division divisionToAdd )
		{
			if( divisionToAdd == null )
				throw( new ArgumentNullException( "divisionToAdd" ) );

			List.Add( divisionToAdd );
			
			return divisionToAdd;
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/23/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="291"> 
		///		<ExpectedInput>Collection containing 1 division object, index 0.</ExpectedInput>
		///		<ExpectedOutput>Valid division object.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2291"> 
		///		<ExpectedInput>Negative integer.</ExpectedInput>
		///		<ExpectedOutput>IndexOutOfRangeException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets division object by index in the collection.
		/// </summary>
		public Division this[int index]
		{
			get
			{
				return (Division)(List[index]);
			}
			set
			{
				List[index] = value;
			}
		}

		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/27/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6744"> 
		///		<ExpectedInput>Division object in collection.</ExpectedInput>
		///		<ExpectedOutput>Valid non-negative index in collection.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="6746"> 
		///		<ExpectedInput>Division object NOT in collection.</ExpectedInput>
		///		<ExpectedOutput>-1.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6745"> 
		///		<ExpectedInput>NA.</ExpectedInput>
		///		<ExpectedOutput>NA.</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Index of the division in the list. 
		/// </summary>
		/// <param name="divisionToFind">Division object</param>
		/// <returns>Index of division in the list, -1 if it's not found.</returns>
		public int IndexOf( Division divisionToFind )
		{
			return List.IndexOf( divisionToFind );
		}
	}
}